#ifndef __CRadioButton__
#define __CRadioButton__

#include "CControlPanel.hpp"
#include "CLatchingButton.hpp"
#include "../Listeners/IActionListener.hpp"

//	===========================================================================

using Exponent::GUI::Controls::CControlPanel;
using Exponent::GUI::Controls::CLatchingButton;
using Exponent::GUI::Listeners::IActionListener;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CRadioButton CRadioButton.hpp
			 * @brief Multiple linked buttons
			 *
			 * A radio button is a panel with a set of buttons\n
			 * To set the postions of the panel, call getButtons,\n
			 * and then loop through the array, remmebering that the\n
			 * radio button itself is a panel and therefore controls are set relative to it..
			 *
			 * @date 19/03/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CRadioButton.hpp,v 1.7 2007/02/08 21:07:54 paul Exp $
			 */
			class CRadioButton : public CControlPanel, public IActionListener
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 * @param numberOfButtons The number of buttons to be displayed as part of the radio button
				 * @param listener The action listener
				 */
				CRadioButton(IControlRoot *root, const long uniqueId, const CRect &area, const long numberOfButtons, IActionListener *listener = NULL);

				/**
				 * Destruction
				 */
				virtual ~CRadioButton();

//	===========================================================================

				/**
				 * Handle the action event
				 * @param event The event to handle
				 */
				virtual void handleActionEvent(const CActionEvent &event);

//	===========================================================================

				/**
				 * Get the selected index
				 * @retval long The index of the currently selected button
				 */
				virtual long getSelectedIndex() const { return m_selectedIndex; }

				/**
				 * Set the selected indx
				 * @param index THe index of the button you want to be selected
				 */
				virtual void setSelectedButton(const long index);

				/**
				 * Get the buttons array
				 * @retval TCountedPointerArray<IControl>* The array of button, guaranteed to be valid
				 * @note The only safe conversion of the controls contained within this is to CLatchingButton, any other conversion is invalid
				 * @see CLatchingButton
				 */
				virtual TCountedPointerArray<IControl> *getButtons() const { return m_controlArray; }

				/**
				 * Set the number of buttons
				 * @param number The number of buttons. Implies reinitialisation of class
				 */
				virtual void setNumberOfButtons(const long number);

				/**
				 * Set the size of the control
				 * @param area The are of the control
				 */
				virtual void setArea(const CRect &area);

//	===========================================================================

			protected:

//	===========================================================================

				long m_selectedIndex;			/**< Which is currently selected */
				long m_numberOfButtons;			/**< How many buttons do we have */
			};
		}
	}
}


#endif	// End of CRadioButton